#pragma once

#include "Links.h"
#include "Common.hpp"
#include "Flag.h"

const
    AREA_NAME_SIZE = 32,
    AREA_DESC_SIZE = 256;


class CTie {
public:
	CTie() {}
	virtual ~CTie() {}

	int getRouteType() const { return routeType; }
	void setRouteType(int newRouteType) { routeType = newRouteType; }

	PLink	getLink()			 { return link; }
	ConstLinkPtr getLink() const { return link; }
	void	setLink(PLink newLink) { link = newLink; }

protected:
	int		routeType;
	PLink	link;
};
typedef CTie*			TiePtr;
typedef const CTie*		ConstTiePtr;
typedef vector<TiePtr>	VTies;


class CAreaGroup {
public:
	CAreaGroup() {}
	virtual ~CAreaGroup() {}

	void           setName(const tstring& newName) { name = newName; }
	const tstring& getName() const                 { return name;    }

	void           setDescription(const tstring& newDesc) { description = newDesc; }
	const tstring& getDescription() const                 { return description;    }

protected:
	tstring	name;
	tstring	description;
};
typedef CAreaGroup* PAreaGroup;


class CFileFlag {
public:
	CFileFlag(const tstring& aFile, const tstring& aMask)
		: file(aFile), mask(aMask), used(false) {}
	CFileFlag(const CFileFlag& instance)
		: file(instance.file), mask(instance.mask), used(instance.used) {}

	CFileFlag& operator =(const CFileFlag& instance) {
		file = instance.file;
		mask = instance.mask;
		used = instance.used;

		return (*this);
	}

	const tstring& getFile() const { return file; }
	const tstring& getMask() const { return mask; }

	bool isUsed() const { return used; }
	void setUsed(bool newUsed) { used = newUsed; }

protected:
	tstring	file;
	tstring	mask;
	bool	used;
};


class CArea {
public:
	CArea();
	virtual ~CArea();

	void           setName(const tstring& newName) { name = newName; }
	const tstring& getName() const                 { return name;    }

	void           setDescription(const tstring& newDesc) { description = newDesc; }
	const tstring& getDescription() const                 { return description;    }

	void getNameDesc(std::string& nameDesc) const;

	void setPath(const tstring& newPath);
	const tstring& getPath() const;

	const tstring& getWorkingPath() const { return workingPath; }

	void setSendPriority(int newPriority) { sendPriority = newPriority; }
	int	 getSendPriority() const { return sendPriority; }

	void setReceivePriority(int newPriority) { receivePriority = newPriority; }
	int	 getReceivePriority() const { return receivePriority; }

	void setOutboundDefined(bool defined) { outboundDefined = defined; }
	bool isOutboundDefined() const        { return outboundDefined;    }

	void setOutboundType(OutboundType newType)	{ outboundType = newType; }
	OutboundType getOutboundType() const		{ return outboundType;    }

	virtual void setChanged(bool newChanged) { changed = newChanged; }
	virtual bool isChanged() const { return changed; }

	static bool isValidName(const tstring& areaName);

	virtual void setFlag(int flag);
	virtual void resetFlag(int flag);
	virtual bool hasFlag(int flag) const;

	PAreaGroup getGroup() { return group; }
	void       setGroup(PAreaGroup newGroup) { group = newGroup; }

	void        addTie(TiePtr newTie) { ties.push_back( newTie ); }
	TiePtr      getTie(int index)       { return ties[index]; }
	ConstTiePtr getTie(int index) const { return ties[index]; }
	TiePtr      getTie(ConstLinkPtr link);
	ConstTiePtr getTie(ConstLinkPtr link) const;

	/**
	 * @return	true when tie removed, false when there is no tie for the specified link
	 */
	bool removeTie(ConstLinkPtr link);

	int getTiesCount() const { return ties.size(); }

	enum flagsEnum {
		FLAG_PASSTHROUGH = 0,
		FLAG_VETO_MANUAL_PURGE,
		FLAG_OPEN_FOR_RESEND
	};

	bool canSend(ConstLinkPtr link) const;
	bool canReceive(ConstLinkPtr link) const;

	void addFileFlag(const CFileFlag& newFlag) { fileFlags.push_back( newFlag ); }
	int  getFileFlagsCount() const { return fileFlags.size(); }
	CFileFlag& getFileFlag(int index) { return fileFlags[index]; }

	void rememberNewFile(const tstring& newFile) { newFiles.push_back( newFile ); }
	void forgetNewFiles() { newFiles.clear(); }
	const tstring& getNewFile(int index) const { return newFiles[index]; }
	int   getNewFilesCount() const { return newFiles.size(); }

	void setTraffic(int newValue) { traffic = newValue; }
	int  getTraffic() const       { return traffic; }
	void increaseTraffic(int increment) { traffic += increment; }

	void clearDescFile(const VTString& vsFileNames) const;
	void clearDescFile(LPCTSTR szFileNames) const;
	void updateDescFile(LPCTSTR szFileName, LPCTSTR szFileDesc, filesize_t fileSize,
                        const VTString& listLDesc) const;

protected:
	PAreaGroup	group;
	tstring		name;
	tstring		description;
	tstring		path;
	tstring		workingPath;

	int			sendPriority;
	int			receivePriority;

	bool			outboundDefined;
	OutboundType	outboundType;

	bool		changed;

	vector<int>	flags;

	VTies		ties;

	/**
	 * let's make fields below flags
	 */
	/*
	bool	vetoManualPurge;
	bool	passThrough;
	bool	openForResend;
	*/

	vector<CFileFlag>	fileFlags;
	VTString			newFiles;

	int					traffic;
};
typedef CArea*	PArea;
